/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers.loot;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.fabric.CustomValidationLootProvider;
import com.tterrag.registrate.fabric.NonNullTriFunction;
import com.tterrag.registrate.mixin.accessor.LootContextParamSetsAccessor;
import com.tterrag.registrate.mixin.accessor.LootTableProviderAccessor;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.providers.loot.RegistrateEntityLootTables;
import com.tterrag.registrate.providers.loot.RegistrateLootTables;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2438;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_58;
import net.minecraft.class_7784;
import net.minecraft.class_7791;

public class RegistrateLootTableProvider
extends class_2438
implements RegistrateProvider,
CustomValidationLootProvider {
    private static final Map<String, LootType<?>> LOOT_TYPES = new HashMap();
    private final AbstractRegistrate<?> parent;
    private final Multimap<LootType<?>, Consumer<? super RegistrateLootTables>> specialLootActions = HashMultimap.create();
    private final Multimap<class_176, Consumer<BiConsumer<class_2960, class_52.class_53>>> lootActions = HashMultimap.create();
    private final Set<RegistrateLootTables> currentLootCreators = new HashSet<RegistrateLootTables>();
    private static final BiMap<class_2960, class_176> SET_REGISTRY = LootContextParamSetsAccessor.getREGISTRY();

    public RegistrateLootTableProvider(AbstractRegistrate<?> parent, FabricDataOutput output) {
        super((class_7784)output, Set.of(), List.of());
        this.parent = parent;
        ((LootTableProviderAccessor)((Object)this)).setSubProviders(this.getTables(output));
    }

    @Override
    public EnvType getSide() {
        return EnvType.SERVER;
    }

    @Override
    public void validate(Map<class_2960, class_52> tables, class_58 context) {
        this.currentLootCreators.forEach(c -> c.validate(tables, context));
    }

    public <T extends RegistrateLootTables> void addLootAction(LootType<T> type, NonNullConsumer<? extends RegistrateLootTables> action) {
        this.specialLootActions.put(type, action);
    }

    public void addLootAction(class_176 set, Consumer<BiConsumer<class_2960, class_52.class_53>> action) {
        this.lootActions.put((Object)set, action);
    }

    private Supplier<class_7791> getLootCreator(AbstractRegistrate<?> parent, LootType<?> type, FabricDataOutput output) {
        return () -> {
            RegistrateLootTables creator = type.getLootCreator(parent, (T cons) -> this.specialLootActions.get((Object)type).forEach(c -> c.accept(cons)), output);
            this.currentLootCreators.add(creator);
            return creator;
        };
    }

    public List<class_2438.class_7790> getTables(FabricDataOutput output) {
        this.parent.genData(ProviderType.LOOT, this);
        this.currentLootCreators.clear();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (LootType<?> type : LOOT_TYPES.values()) {
            builder.add((Object)new class_2438.class_7790(this.getLootCreator(this.parent, type, output), type.getLootSet()));
        }
        for (class_176 set : SET_REGISTRY.values()) {
            builder.add((Object)new class_2438.class_7790(() -> callback -> this.lootActions.get((Object)set).forEach(a -> a.accept(callback)), set));
        }
        return builder.build();
    }

    public static interface LootType<T extends RegistrateLootTables> {
        public static final LootType<RegistrateBlockLootTables> BLOCK = LootType.register("block", class_173.field_1172, RegistrateBlockLootTables::new);
        public static final LootType<RegistrateEntityLootTables> ENTITY = LootType.register("entity", class_173.field_1173, RegistrateEntityLootTables::new);

        public T getLootCreator(AbstractRegistrate<?> var1, Consumer<T> var2, FabricDataOutput var3);

        public class_176 getLootSet();

        public static <T extends RegistrateLootTables> LootType<T> register(String name, final class_176 set, final NonNullTriFunction<AbstractRegistrate, Consumer<T>, FabricDataOutput, T> factory) {
            LootType type = new LootType<T>(){

                @Override
                public T getLootCreator(AbstractRegistrate<?> parent, Consumer<T> callback, FabricDataOutput output) {
                    return (RegistrateLootTables)factory.apply(parent, callback, output);
                }

                @Override
                public class_176 getLootSet() {
                    return set;
                }
            };
            LOOT_TYPES.put(name, type);
            return type;
        }
    }
}

